#!/bin/bash

ScriptHome=$(echo $HOME)
ScriptPath="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
plist="${ScriptHome}/Library/Preferences/liquidcommander.slsoft.de"

no_devices_match="No devices matches available drivers and selection criteria."
no_device="No devices found."

liquidctl="/usr/local/bin/./liquidctl"

function initial()
{
    mkdir "${ScriptHome}"/.lq_temp
}

function list_devices()
{
    result=$( $liquidctl list )
    if [[ "$result" = "" ]]; then
        echo "$no_device"
        defaults write "$plist" "Error" "no_devices_found"
    fi
}

function status()
{
    $liquidctl status > "${ScriptHome}"/.lq_temp/status
    if [[ "$?" != "0" ]]; then
        echo "$no_devices_match"
        defaults write "$plist" "Error" "no_match"
        exit
    fi
    
    model=$( cat "${ScriptHome}"/.lq_temp/status |head -n 1 |xargs )
    liquid_temperature=$( cat "${ScriptHome}"/.lq_temp/status |grep -w "Liquid temperature" |sed 's/.*re//g' |xargs )
    fan_speed=$( cat "${ScriptHome}"/.lq_temp/status |grep -w "Fan speed" |sed 's/.*eed//g' |xargs )
    pump_speed=$( cat "${ScriptHome}"/.lq_temp/status |grep -w "Pump speed" |sed 's/.*eed//g' |xargs )
    firmware_version=$( cat "${ScriptHome}"/.lq_temp/status |grep -w "Firmware version" |sed 's/.*ion//g' |xargs )
    
    defaults write "$plist" "Model" "$model"
    defaults write "$plist" "Liquid temperature" "$liquid_temperature"
    defaults write "$plist" "Fan speed" "$fan_speed"
    defaults write "$plist" "Pump speed" "$pump_speed"
    defaults write "$plist" "Firmware version" "$firmware_version"
    
}

function initialize()
{
    initialize_all=$( defaults read "$plist" "Initialize all" )
    
    if [[ "$initialize_all" = "1" ]]; then
        run=$( $liquidctl initialize all )
            if [[ $? != "0" ]]; then
                echo "$no_devices_match"
                defaults write "$plist" "Error" "no_match"
            fi
    else
        run=$( $liquidctl initialize )
            if [[ $? != "0" ]]; then
                echo "$no_devices_match"
                defaults write "$plist" "Error" "no_match"
            fi
    fi
}

function clean()
{
    rm -rf "${ScriptHome}"/.lq_temp
}


$1
